/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.global.history;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.common.LazyMap;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistory;

public class PlayerHistoryStorage
implements LazyMap<UUID, PlayerHistory> {
    private static PlayerHistoryStorage instance;
    private static Map<UUID, PlayerHistory> storage;

    private PlayerHistoryStorage() {
        storage = new HashMap<UUID, PlayerHistory>();
    }

    public static PlayerHistoryStorage getInstance() {
        if (instance == null) {
            instance = new PlayerHistoryStorage();
        }
        return instance;
    }

    @Override
    public PlayerHistory getOrCreate(UUID uuid) {
        if (!storage.containsKey(uuid)) {
            storage.put(uuid, new PlayerHistory());
        }
        return storage.get(uuid);
    }

    @Override
    public void put(UUID uuid, PlayerHistory history) {
        storage.put(uuid, history);
    }

    @Override
    public void clear() {
        storage.clear();
    }

    @Override
    public void remove(UUID uuid) {
        storage.remove(uuid);
    }

    @Override
    public Iterable<? extends Map.Entry<UUID, PlayerHistory>> entrySet() {
        return storage.entrySet();
    }
}

